/*
In the Getting Started Tutorial, you learnt how resolve an ORD and read a live value.

Now we're going to extend that original example by seeing how we can 'do something' to a Station by invoking an Action.
*/

// First let's resolve an ORD to a writable point...
var sub = new baja.Subscriber();

// Subscribe to a writable point so we receive notification when it's output changes!
sub.attach("changed", function (prop, cx) {
  if (prop.getName() === "out") {
    baja.outln("Out: " + this.getOutDisplay());
  }
});

baja.Ord.make("station:|slot:/BajaScriptTutorials/NumericWritable").get({
  ok: function (point) {
    // This ok function handler is called once the writable point has been resolved and subscribed
    
    // Invoking the 'override' Action on a point requires an argument. 
    // Therefore, we first need to create a baja:NumericOverride object...
    var overrideVal = baja.$("control:NumericOverride");
    
    // Override with this value for one minute
    overrideVal.setValue(123);
    overrideVal.setDuration(baja.RelTime.make({seconds: 10}));
    
    // Invoke the Action on the point. This will result in an asynchronous network call...
    point.override(overrideVal);
    
    // The Action can also be invoked through the baja.Component#invoke method...
    /*
    point.invoke({
      slot: "override",
      value: overrideVal
    });
    */
  },
  subscriber: sub
});

// Note that if other students are also going through this tutorial on this Station right now, then you may see some unexpected results!
